/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Operations;

public class Search {
    public static int lin(int[] data, int val) {
        return Search.lin(data, val, 0, data.length);
    }

    private static int lin(int[] data, int val, int start_index, int end_index) {
        int i = start_index;
        while (i < end_index) {
            if (data[i] == val) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int bin_near(int[] data, int val) {
        return Search.bin(data, val, 0, data.length, true);
    }

    public static int bin(int[] data, int val) {
        return Search.bin(data, val, 0, data.length, false);
    }

    private static int bin(int[] data, int val, int start_index, int end_index, boolean return_nearest) {
        int lower = start_index;
        int upper = end_index;
        while (lower < upper) {
            int mid = (lower + upper) / 2;
            if (data[mid] == val) {
                return mid;
            }
            if (data[mid] > val) {
                upper = mid;
                continue;
            }
            lower = mid + 1;
        }
        if (return_nearest) {
            if (lower > start_index && lower < end_index && val - data[lower - 1] < data[lower] - val) {
                return lower - 1;
            }
            return lower;
        }
        return -1;
    }

    public static int bin(Object[] data, Object key) {
        return Search.bin(data, key, 0, data.length);
    }

    public static int bin(Object[] data, Object key, int start_index, int end_index) {
        int lower = start_index;
        int upper = end_index;
        while (lower < upper) {
            int mid = (lower + upper) / 2;
            Comparable midVal = (Comparable)data[mid];
            int compare = midVal.compareTo(key);
            if (compare == 0) {
                return mid;
            }
            if (compare > 0) {
                upper = mid;
                continue;
            }
            lower = mid + 1;
        }
        return -1;
    }
}

